<?php
/*
Plugin Name: Axl Woo Sales Countdown
Plugin URI:  https://axlmulat.com
Description: Sales Countdown Timer  is the part of quick act psychology to the customer to buy immediately.
Version:     1.0
Author:      Axl Mulat
Author URI:  https://axlmulat.com
License:     GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: axl-woo-sales-countdown
Domain Path: /languages
*/

function sales_timer_echo_product() {
		
		global $product;
		$regular_price 	= get_post_meta( $product->get_id(), '_sale_price_dates_to', true );
		if(!empty($regular_price)) {
	?>
		<p id="sales_timer_display" style="color:red" data-date="<?php echo date('Y-m-d',$regular_price);?>"></p>	
	<?php
		}
		
} // end function
add_action( 'woocommerce_single_product_summary', 'sales_timer_echo_product', 12 ); // hook number

function sales_timer_scripts() {
				wp_enqueue_script('xcountdown_plugin_min', path_join(WP_PLUGIN_URL, basename(dirname(__FILE__)). "/js/jquery.plugin.min.js"), array("jquery"), '', true); 
				wp_enqueue_script('xcountdown_js_min', path_join(WP_PLUGIN_URL, basename(dirname(__FILE__)). "/js/jquery.countdown.min.js"), array("jquery"), '', true); 
				wp_enqueue_script('xcustom_product_countdown', path_join(WP_PLUGIN_URL, basename(dirname(__FILE__)). "/js/product-countdown.js"), array("jquery"), '', true);
}
add_action( 'wp_enqueue_scripts', 'sales_timer_scripts' );