<?php
function my_theme_enqueue_styles() {

    $parent_style = 'parent-style'; // This is 'twentyfifteen-style' for the Twenty Fifteen theme.

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style ),
        wp_get_theme()->get('Version')
    );
}
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

// 3. echo Sale Timer
function sales_timer_echo_product() {
		
		global $product;
		$regular_price 	= get_post_meta( $product->get_id(), '_sale_price_dates_to', true );
		if(!empty($regular_price)) {
	?>
		<p id="sales_timer_display" style="color:red" data-date="<?php echo date('Y-m-d',$regular_price);?>"></p>	
	<?php
		}
		
} // end function
add_action( 'woocommerce_single_product_summary', 'sales_timer_echo_product', 12 ); // hook number

function sales_timer_scripts() {
				wp_enqueue_script('countdown_plugin_min', "/wp-content/themes/" . basename(dirname(__FILE__)) . "/customjs/jquery.plugin.min.js" , array("jquery"), '', true); 
				wp_enqueue_script('countdown_js_min', "/wp-content/themes/" . basename(dirname(__FILE__)) . "/customjs/jquery.countdown.min.js" , array("jquery"), '', true); 
				wp_enqueue_script('custom_product_countdown', "/wp-content/themes/" . basename(dirname(__FILE__)) . "/customjs/product-countdown.js" , array("jquery"), '', true);
}
add_action( 'wp_enqueue_scripts', 'sales_timer_scripts' );